/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client;

import edu.yale.its.tp.cas.util.SecureURL;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceTicketValidator {
    private String casValidateUrl;
    private String proxyCallbackUrl;
    private String st;
    private String service;
    private String pgtIou;
    private String user;
    private String errorCode;
    private String errorMessage;
    private String entireResponse;
    private Map userMap = new HashMap();
    private boolean renew = false;
    private boolean attemptedAuthentication;
    private boolean successfulAuthentication;
    static /* synthetic */ Class class$edu$yale$its$tp$cas$client$ServiceTicketValidator;

    public static void main(String[] args) throws Exception {
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        ServiceTicketValidator sv = new ServiceTicketValidator();
        sv.setCasValidateUrl("https://portal1.wss.yale.edu/cas/serviceValidate");
        sv.setProxyCallbackUrl("https://portal1.wss.yale.edu/casProxy/receptor");
        sv.setService(args[0]);
        sv.setServiceTicket(args[1]);
        sv.validate();
        System.out.println(sv.getResponse());
        System.out.println();
        if (sv.isAuthenticationSuccesful()) {
            System.out.println("user: " + sv.getUser());
            System.out.println("pgtIou: " + sv.getPgtIou());
        } else {
            System.out.println("error code: " + sv.getErrorCode());
            System.out.println("error message: " + sv.getErrorMessage());
        }
    }

    public Map getUserMap() {
        return this.userMap;
    }

    public void setCasValidateUrl(String x) {
        this.casValidateUrl = x;
    }

    public String getCasValidateUrl() {
        return this.casValidateUrl;
    }

    public void setProxyCallbackUrl(String x) {
        this.proxyCallbackUrl = x;
    }

    public void setRenew(boolean b) {
        this.renew = b;
    }

    public String getProxyCallbackUrl() {
        return this.proxyCallbackUrl;
    }

    public void setServiceTicket(String x) {
        this.st = x;
    }

    public void setService(String x) {
        this.service = x;
    }

    public String getUser() {
        return this.user;
    }

    public String getPgtIou() {
        return this.pgtIou;
    }

    public boolean isAuthenticationSuccesful() {
        return this.successfulAuthentication;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getResponse() {
        return this.entireResponse;
    }

    public void validate() throws IOException, SAXException, ParserConfigurationException {
        String response;
        if (this.casValidateUrl == null || this.st == null) {
            throw new IllegalStateException("must set validation URL and ticket");
        }
        this.clear();
        this.attemptedAuthentication = true;
        StringBuffer sb = new StringBuffer();
        sb.append(this.casValidateUrl);
        if (this.casValidateUrl.indexOf(63) == -1) {
            sb.append('?');
        } else {
            sb.append('&');
        }
        sb.append("service=" + this.service + "&ticket=" + this.st);
        if (this.proxyCallbackUrl != null) {
            sb.append("&pgtUrl=" + this.proxyCallbackUrl);
        }
        if (this.renew) {
            sb.append("&renew=true");
        }
        String url = sb.toString();
        this.entireResponse = response = SecureURL.retrieve(url);
        if (response != null) {
            XMLReader r = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            r.setFeature("http://xml.org/sax/features/namespaces", false);
            r.setContentHandler(this.newHandler());
            r.parse(new InputSource(new StringReader(response)));
        }
    }

    protected DefaultHandler newHandler() {
        return new Handler();
    }

    protected void clear() {
        this.errorMessage = null;
        this.pgtIou = null;
        this.user = null;
        this.attemptedAuthentication = false;
        this.successfulAuthentication = false;
    }

    public boolean isRenew() {
        return this.renew;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append((class$edu$yale$its$tp$cas$client$ServiceTicketValidator == null ? (class$edu$yale$its$tp$cas$client$ServiceTicketValidator = ServiceTicketValidator.class$("edu.yale.its.tp.cas.client.ServiceTicketValidator")) : class$edu$yale$its$tp$cas$client$ServiceTicketValidator).getName());
        if (this.casValidateUrl != null) {
            sb.append(" casValidateUrl=[");
            sb.append(this.casValidateUrl);
            sb.append("]");
        }
        if (this.proxyCallbackUrl != null) {
            sb.append(" proxyCallbackUrl=[");
            sb.append(this.proxyCallbackUrl);
            sb.append("]");
        }
        if (this.st != null) {
            sb.append(" ticket=[");
            sb.append(this.st);
            sb.append("]");
        }
        if (this.service != null) {
            sb.append(" service=[");
            sb.append(this.service);
            sb.append("]");
        }
        if (this.pgtIou != null) {
            sb.append(" pgtIou=[");
            sb.append(this.pgtIou);
            sb.append("]");
        }
        if (this.user != null) {
            sb.append(" user=[");
            sb.append(this.user);
            sb.append("]");
        }
        if (this.errorCode != null) {
            sb.append(" errorCode=[");
            sb.append(this.errorCode);
            sb.append("]");
        }
        if (this.errorMessage != null) {
            sb.append(" errorMessage=[");
            sb.append(this.errorMessage);
            sb.append("]");
        }
        sb.append(" renew=");
        sb.append(this.renew);
        if (this.entireResponse != null) {
            sb.append(" entireResponse=[");
            sb.append(this.entireResponse);
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class Handler
    extends DefaultHandler {
        protected static final String AUTHENTICATION_SUCCESS = "cas:authenticationSuccess";
        protected static final String AUTHENTICATION_FAILURE = "cas:authenticationFailure";
        protected static final String PROXY_GRANTING_TICKET = "cas:proxyGrantingTicket";
        protected static final String USER = "cas:user";
        protected static final String ATTRIBUTES = "cas:attributes";
        protected StringBuffer currentText = new StringBuffer();
        protected boolean authenticationSuccess = false;
        protected boolean authenticationFailure = false;
        protected boolean inAttributes = false;
        protected String netid;
        protected String pgtIou;
        protected String errorCode;
        protected String errorMessage;

        protected Handler() {
        }

        public void startElement(String ns, String ln, String qn, Attributes a) {
            this.currentText = new StringBuffer();
            if (qn.equals(AUTHENTICATION_SUCCESS)) {
                this.authenticationSuccess = true;
            } else if (qn.equals(AUTHENTICATION_FAILURE)) {
                this.authenticationFailure = true;
                this.errorCode = a.getValue("code");
                if (this.errorCode != null) {
                    this.errorCode = this.errorCode.trim();
                }
            } else if (qn.equals(ATTRIBUTES)) {
                this.inAttributes = true;
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.currentText.append(ch, start, length);
        }

        public void endElement(String ns, String ln, String qn) throws SAXException {
            if (this.authenticationSuccess) {
                if (qn.equals(USER)) {
                    ServiceTicketValidator.this.user = this.currentText.toString().trim();
                }
                if (qn.equals(PROXY_GRANTING_TICKET)) {
                    this.pgtIou = this.currentText.toString().trim();
                }
                if (qn.equals(ATTRIBUTES)) {
                    this.inAttributes = false;
                }
                if (this.inAttributes && qn.startsWith("cas:")) {
                    String name = qn.substring(4);
                    String val = this.currentText.toString().trim();
                    ServiceTicketValidator.this.userMap.put(name, val);
                }
            } else if (this.authenticationFailure && qn.equals(AUTHENTICATION_FAILURE)) {
                this.errorMessage = this.currentText.toString().trim();
            }
        }

        public void endDocument() throws SAXException {
            if (this.authenticationSuccess) {
                ServiceTicketValidator.this.user = ServiceTicketValidator.this.user;
                ServiceTicketValidator.this.pgtIou = this.pgtIou;
                ServiceTicketValidator.this.successfulAuthentication = true;
            } else if (this.authenticationFailure) {
                ServiceTicketValidator.this.errorMessage = this.errorMessage;
                ServiceTicketValidator.this.errorCode = this.errorCode;
                ServiceTicketValidator.this.successfulAuthentication = false;
            } else {
                throw new SAXException("no indication of success or failure from CAS");
            }
        }
    }
}

