/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client.filter;

import edu.yale.its.tp.cas.client.CASAuthenticationException;
import edu.yale.its.tp.cas.client.CASReceipt;
import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import edu.yale.its.tp.cas.client.SingleSignOutHandler;
import edu.yale.its.tp.cas.client.SingleSignOutHttpSessionListener;
import edu.yale.its.tp.cas.client.Util;
import edu.yale.its.tp.cas.client.filter.CASFilterRequestWrapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CASFilter
implements Filter {
    private static Log log = LogFactory.getLog((Class)(class$edu$yale$its$tp$cas$client$filter$CASFilter == null ? (class$edu$yale$its$tp$cas$client$filter$CASFilter = CASFilter.class$("edu.yale.its.tp.cas.client.filter.CASFilter")) : class$edu$yale$its$tp$cas$client$filter$CASFilter));
    public static final String LOGIN_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.loginUrl";
    public static final String VALIDATE_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.validateUrl";
    public static final String SERVICE_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.serviceUrl";
    public static final String SERVERNAME_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.serverName";
    public static final String RENEW_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.renew";
    public static final String AUTHORIZED_PROXY_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.authorizedProxy";
    public static final String PROXY_CALLBACK_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.proxyCallbackUrl";
    public static final String WRAP_REQUESTS_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.wrapRequest";
    public static final String GATEWAY_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.gateway";
    public static final String CAS_FILTER_USER = "edu.yale.its.tp.cas.client.filter.user";
    public static final String CAS_FILTER_RECEIPT = "edu.yale.its.tp.cas.client.filter.receipt";
    private static final String CAS_FILTER_GATEWAYED = "edu.yale.its.tp.cas.client.filter.didGateway";
    private static final String CAS_FILTER_NEEDSSOLOGOUT = "edu.yale.its.tp.cas.client.filter.needSSOLogout";
    private static final String CAS_FILTER_REDIRECT = "edu.yale.its.tp.cas.client.filter.redirect";
    private String casLogin;
    private String casValidate;
    private String casServiceUrl;
    private String casServerName;
    private String casProxyCallbackUrl;
    private boolean casRenew;
    private boolean wrapRequest;
    private boolean casGateway = false;
    private boolean needSSOLogout = false;
    private boolean redirectAfterValidation = true;
    private List authorizedProxies = new ArrayList();
    static /* synthetic */ Class class$edu$yale$its$tp$cas$client$filter$CASFilter;

    public void init(FilterConfig config) throws ServletException {
        this.casLogin = config.getInitParameter(LOGIN_INIT_PARAM);
        this.casValidate = config.getInitParameter(VALIDATE_INIT_PARAM);
        this.casServiceUrl = config.getInitParameter(SERVICE_INIT_PARAM);
        String casAuthorizedProxy = config.getInitParameter(AUTHORIZED_PROXY_INIT_PARAM);
        this.casRenew = Boolean.valueOf(config.getInitParameter(RENEW_INIT_PARAM));
        this.casServerName = config.getInitParameter(SERVERNAME_INIT_PARAM);
        this.casProxyCallbackUrl = config.getInitParameter(PROXY_CALLBACK_INIT_PARAM);
        String wrapRequestParam = config.getInitParameter(WRAP_REQUESTS_INIT_PARAM);
        this.wrapRequest = wrapRequestParam == null ? true : Boolean.valueOf(config.getInitParameter(WRAP_REQUESTS_INIT_PARAM));
        this.casGateway = Boolean.valueOf(config.getInitParameter(GATEWAY_INIT_PARAM));
        this.needSSOLogout = Boolean.valueOf(config.getInitParameter(CAS_FILTER_NEEDSSOLOGOUT));
        if (config.getInitParameter(CAS_FILTER_REDIRECT) != null) {
            this.redirectAfterValidation = Boolean.valueOf(config.getInitParameter(CAS_FILTER_REDIRECT));
        }
        if (this.casGateway && Boolean.valueOf(this.casRenew).booleanValue()) {
            throw new ServletException("gateway and renew cannot both be true in filter configuration");
        }
        if (this.casServerName != null && this.casServiceUrl != null) {
            throw new ServletException("serverName and serviceUrl cannot both be set: choose one.");
        }
        if (this.casServerName == null && this.casServiceUrl == null) {
            throw new ServletException("one of serverName or serviceUrl must be set.");
        }
        if (this.casServiceUrl != null && !this.casServiceUrl.startsWith("https://") && !this.casServiceUrl.startsWith("http://")) {
            throw new ServletException("service URL must start with http:// or https://; its current value is [" + this.casServiceUrl + "]");
        }
        if (this.casValidate == null) {
            throw new ServletException("validateUrl parameter must be set.");
        }
        if (!this.casValidate.startsWith("https://") && !this.casValidate.startsWith("http://")) {
            throw new ServletException("validateUrl must start with http:// or https://, its current value is [" + this.casValidate + "]");
        }
        if (casAuthorizedProxy != null) {
            StringTokenizer casProxies = new StringTokenizer(casAuthorizedProxy);
            while (casProxies.hasMoreTokens()) {
                String anAuthorizedProxy = casProxies.nextToken();
                if (!anAuthorizedProxy.startsWith("https://") && !anAuthorizedProxy.startsWith("http://")) {
                    throw new ServletException("CASFilter initialization parameter for authorized proxies must be a whitespace delimited list of authorized proxies.  Authorized proxies must be (http https) addresses.  This one wasn't: [" + anAuthorizedProxy + "]");
                }
                this.authorizedProxies.add(anAuthorizedProxy);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CASFilter initialized as: [" + this.toString() + "]"));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain fc) throws ServletException, IOException {
        HttpSession session;
        CASReceipt receipt;
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering doFilter()");
        }
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            log.error((Object)"doFilter() called on a request or response that was not an HttpServletRequest or response.");
            throw new ServletException("CASFilter protects only HTTP resources");
        }
        if (this.needSSOLogout) {
            SingleSignOutHandler handler = SingleSignOutHttpSessionListener.getSingleSignOutHandler();
            if (handler.isTokenRequest((HttpServletRequest)request)) {
                handler.recordSession((HttpServletRequest)request);
            } else if (handler.isLogoutRequest((HttpServletRequest)request)) {
                handler.destroySession((HttpServletRequest)request);
                return;
            }
        }
        if (this.casProxyCallbackUrl != null && this.casProxyCallbackUrl.endsWith(((HttpServletRequest)request).getRequestURI()) && request.getParameter("pgtId") != null && request.getParameter("pgtIou") != null) {
            log.trace((Object)"passing through what we hope is CAS's request for proxy ticket receptor.");
            fc.doFilter(request, response);
            return;
        }
        if (this.wrapRequest) {
            log.trace((Object)"Wrapping request with CASFilterRequestWrapper.");
            request = new CASFilterRequestWrapper((HttpServletRequest)request);
        }
        if ((receipt = (CASReceipt)(session = ((HttpServletRequest)request).getSession()).getAttribute(CAS_FILTER_RECEIPT)) != null && this.isReceiptAcceptable(receipt)) {
            log.trace((Object)"CAS_FILTER_RECEIPT attribute was present and acceptable - passing  request through filter..");
            fc.doFilter(request, response);
            return;
        }
        String ticket = request.getParameter("ticket");
        if (ticket == null || ticket.equals("")) {
            log.trace((Object)"CAS ticket was not present on request.");
            boolean didGateway = Boolean.valueOf((String)session.getAttribute(CAS_FILTER_GATEWAYED));
            if (this.casLogin == null) {
                log.fatal((Object)"casLogin was not set, so filter cannot redirect request for authentication.");
                throw new ServletException("When CASFilter protects pages that do not receive a 'ticket' parameter, it needs a edu.yale.its.tp.cas.client.filter.loginUrl filter parameter");
            }
            if (!didGateway) {
                log.trace((Object)"Did not previously gateway.  Setting session attribute to true.");
                session.setAttribute(CAS_FILTER_GATEWAYED, (Object)"true");
                this.redirectToCAS((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            log.trace((Object)"Previously gatewayed.");
            if (this.casGateway || session.getAttribute(CAS_FILTER_USER) != null) {
                log.trace((Object)"casGateway was true and CAS_FILTER_USER set: passing request along filter chain.");
                fc.doFilter(request, response);
                return;
            }
            session.setAttribute(CAS_FILTER_GATEWAYED, (Object)"true");
            this.redirectToCAS((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        try {
            receipt = this.getAuthenticatedUser((HttpServletRequest)request);
        }
        catch (CASAuthenticationException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        if (!this.isReceiptAcceptable(receipt)) {
            throw new ServletException("Authentication was technically successful but rejected as a matter of policy. [" + receipt + "]");
        }
        if (session != null) {
            session.setAttribute(CAS_FILTER_USER, (Object)receipt.getUserName());
            session.setAttribute(CAS_FILTER_RECEIPT, (Object)receipt);
            session.removeAttribute(CAS_FILTER_GATEWAYED);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("validated ticket to get authenticated receipt [" + receipt + "], now passing request along filter chain."));
        }
        if (this.redirectAfterValidation) {
            ((HttpServletResponse)response).sendRedirect(this.constructServiceUrl((HttpServletRequest)request, (HttpServletResponse)response));
            return;
        }
        fc.doFilter(request, response);
        log.trace((Object)"returning from doFilter()");
    }

    private boolean isReceiptAcceptable(CASReceipt receipt) {
        if (receipt == null) {
            throw new IllegalArgumentException("Cannot evaluate a null receipt.");
        }
        if (this.casRenew && !receipt.isPrimaryAuthentication()) {
            return false;
        }
        return !receipt.isProxied() || this.authorizedProxies.contains(receipt.getProxyingService());
    }

    private CASReceipt getAuthenticatedUser(HttpServletRequest request) throws ServletException, CASAuthenticationException {
        log.trace((Object)"entering getAuthenticatedUser()");
        ProxyTicketValidator pv = null;
        pv = new ProxyTicketValidator();
        pv.setCasValidateUrl(this.casValidate);
        pv.setServiceTicket(request.getParameter("ticket"));
        pv.setService(this.getService(request));
        pv.setRenew(this.casRenew);
        if (this.casProxyCallbackUrl != null) {
            pv.setProxyCallbackUrl(this.casProxyCallbackUrl);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("about to validate ProxyTicketValidator: [" + pv + "]"));
        }
        return CASReceipt.getReceipt(pv);
    }

    private String getService(HttpServletRequest request) throws ServletException {
        String serviceString;
        log.trace((Object)"entering getService()");
        if (this.casServerName == null && this.casServiceUrl == null) {
            throw new ServletException("need one of the following configuration parameters: edu.yale.its.tp.cas.client.filter.serviceUrl or edu.yale.its.tp.cas.client.filter.serverName");
        }
        if (this.casServiceUrl != null) {
            try {
                serviceString = URLEncoder.encode(this.casServiceUrl, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                serviceString = this.casServiceUrl;
            }
        } else {
            serviceString = Util.getService(request, this.casServerName);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("returning from getService() with service [" + serviceString + "]"));
        }
        return serviceString;
    }

    private void redirectToCAS(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering redirectToCAS()");
        }
        String casLoginString = this.casLogin + "?service=" + this.getService(request) + (this.casRenew ? "&renew=true" : "") + (this.casGateway ? "&gateway=true" : "");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirecting browser to [" + casLoginString + ")"));
        }
        response.sendRedirect(casLoginString);
        if (log.isTraceEnabled()) {
            log.trace((Object)"returning from redirectToCAS()");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[CASFilter:");
        sb.append(" casGateway=");
        sb.append(this.casGateway);
        sb.append(" wrapRequest=");
        sb.append(this.wrapRequest);
        sb.append(" casAuthorizedProxies=[");
        sb.append(this.authorizedProxies);
        sb.append("]");
        if (this.casLogin != null) {
            sb.append(" casLogin=[");
            sb.append(this.casLogin);
            sb.append("]");
        } else {
            sb.append(" casLogin=NULL!!!!!");
        }
        if (this.casProxyCallbackUrl != null) {
            sb.append(" casProxyCallbackUrl=[");
            sb.append(this.casProxyCallbackUrl);
            sb.append("]");
        }
        if (this.casRenew) {
            sb.append(" casRenew=true");
        }
        if (this.casServerName != null) {
            sb.append(" casServerName=[");
            sb.append(this.casServerName);
            sb.append("]");
        }
        if (this.casServiceUrl != null) {
            sb.append(" casServiceUrl=[");
            sb.append(this.casServiceUrl);
            sb.append("]");
        }
        if (this.casValidate != null) {
            sb.append(" casValidate=[");
            sb.append(this.casValidate);
            sb.append("]");
        } else {
            sb.append(" casValidate=NULL!!!");
        }
        return sb.toString();
    }

    public void destroy() {
    }

    private String constructServiceUrl(HttpServletRequest request, HttpServletResponse response) {
        StringBuffer buffer = new StringBuffer();
        if (!this.casServerName.startsWith("https://") && !this.casServerName.startsWith("http://")) {
            buffer.append(request.isSecure() ? "https://" : "http://");
        }
        buffer.append(this.casServerName);
        buffer.append(request.getRequestURI());
        if (request.getQueryString() != null) {
            int location = request.getQueryString().indexOf("ticket=");
            if (location == 0) {
                return buffer.toString();
            }
            buffer.append("?");
            if (location == -1) {
                buffer.append(request.getQueryString());
            } else if (location > 0) {
                int actualLocation = request.getQueryString().indexOf("&ticket=");
                if (actualLocation == -1) {
                    buffer.append(request.getQueryString());
                } else if (actualLocation > 0) {
                    buffer.append(request.getQueryString().substring(0, actualLocation));
                }
            }
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

